class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Mens Fitness'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''


    keep_only_tags = [dict(name='div', attrs={'id':'content_items'})]
    remove_attributes = ['style', '']

    remove_tags_before = dict(id='')
    remove_tags = [dict(name='div', attrs={'class':['','']}),
                   dict(name='div', attrs={'id':['','',]}),
                   dict(name='ul', attrs={'class':['']}),
                   dict(name='ul', attrs={'id':['']}),
	dict(name='ol', attrs={'id':['']}),
	dict(name='span', attrs={'name':['']}),
	dict(name='p', attrs={'id':''}),
                   dict(name='img'),]

    feeds          = (u'News', u'http://www.mensfitness.com/rss_global/')



    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		
    
